package org.msh.tb.reports2.variables;

import org.msh.reports.keys.Key;
import org.msh.reports.query.SQLDefs;
import org.msh.reports.variables.Variable;

/**
 * Define a variable that doesn't include any information in the table.
 * This is to be used if no variable is defined in a column or row
 * Created by Ricardo on 09/07/2014.
 */
public class EmptyVariable implements Variable {

    // the ID of the empty variable
    private String id;

    /**
     * Declare default constructor
     * @param id the id user by this variable
     */
    public EmptyVariable(String id) {
        super();
        this.id = id;
    }

    @Override
    public void prepareVariableQuery(SQLDefs def, int iteration) {
        // include a fake field just to count as a column
        def.select('"' + id + '"');
    }

    @Override
    public Key createKey(Object values, int iteration) {
        return Key.of(values);
    }

    @Override
    public String getDisplayText(Key key) {
        return "Total";
    }

    @Override
    public int compareValues(Key val1, Key val2) {
        return 0;
    }


    @Override
    public Object[] getDomain() {
        return null;
    }

    @Override
    public boolean isGrouped() {
        return false;
    }

    @Override
    public String getGroupDisplayText(Key key) {
        return null;
    }

    @Override
    public int getIteractionCount() {
        return 0;
    }

    @Override
    public boolean isTotalEnabled() {
        return false;
    }

    @Override
    public Object getUnitType() {
        return null;
    }

    @Override
    public String getUnitTypeLabel() {
        return null;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String getLabel() {
        return "Total";
    }
}
